"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throwIfEmpty = void 0;
const EmptyError_js_1 = require("../util/EmptyError.js");
const Observable_js_1 = require("../Observable.js");
function throwIfEmpty(errorFactory = defaultErrorFactory) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let hasValue = false;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => (hasValue ? destination.complete() : destination.error(errorFactory())),
        }));
    });
}
exports.throwIfEmpty = throwIfEmpty;
function defaultErrorFactory() {
    return new EmptyError_js_1.EmptyError();
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/6757269838ae9ac4caaa2be13f396fdfbcf1f9a0/node_modules/rxjs/dist/cjs/internal/operators/throwIfEmpty.js.map