import { defineIntegration, normalize } from '@sentry/core';
import { addScopeListener } from '../../common/scope.js';
import { getIPC } from '../ipc.js';

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup(client) {
            const ipc = getIPC(client);
            addScopeListener((merged, changed) => {
                ipc.sendScope(JSON.stringify(normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

export { scopeToMainIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/6757269838ae9ac4caaa2be13f396fdfbcf1f9a0/node_modules/@sentry/electron/esm/renderer/integrations/scope-to-main.js.map
