import { EmptyError } from '../util/EmptyError.js';
import { Observable, operate } from '../Observable.js';
export function throwIfEmpty(errorFactory = defaultErrorFactory) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => (hasValue ? destination.complete() : destination.error(errorFactory())),
        }));
    });
}
function defaultErrorFactory() {
    return new EmptyError();
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/656af3704923280dedba3ccd49cfaf9b9d456e90/node_modules/rxjs/dist/esm/internal/operators/throwIfEmpty.js.map