function addHeader(responseHeaders = {}, name, value) {
    if (responseHeaders[name]) {
        const existing = responseHeaders[name];
        if (Array.isArray(existing)) {
            existing.push(value);
        }
        else {
            responseHeaders[name] = [existing, value];
        }
    }
    else {
        responseHeaders[name] = value;
    }
    return { responseHeaders };
}
/**
 * Adds a header to a session's web request
 */
function addHeaderToSession(sesh, header, value) {
    sesh.webRequest.onHeadersReceived((details, callback) => {
        callback(addHeader(details.responseHeaders, header, value));
    });
}

export { addHeaderToSession };//# sourceMappingURL=http://go/sourcemap/sourcemaps/656af3704923280dedba3ccd49cfaf9b9d456e90/node_modules/@sentry/electron/esm/main/header-injection.js.map
