"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.onErrorResumeNext = void 0;
const Observable_js_1 = require("../Observable.js");
const argsOrArgArray_js_1 = require("../util/argsOrArgArray.js");
const noop_js_1 = require("../util/noop.js");
function onErrorResumeNext(...sources) {
    const nextSources = (0, argsOrArgArray_js_1.argsOrArgArray)(sources);
    return new Observable_js_1.Observable((destination) => {
        let sourceIndex = 0;
        const subscribeNext = () => {
            if (sourceIndex < nextSources.length) {
                let nextSource;
                try {
                    nextSource = (0, Observable_js_1.from)(nextSources[sourceIndex++]);
                }
                catch (err) {
                    subscribeNext();
                    return;
                }
                const innerSubscriber = (0, Observable_js_1.operate)({ destination, error: noop_js_1.noop, complete: noop_js_1.noop });
                nextSource.subscribe(innerSubscriber);
                innerSubscriber.add(subscribeNext);
            }
            else {
                destination.complete();
            }
        };
        subscribeNext();
    });
}
exports.onErrorResumeNext = onErrorResumeNext;//# sourceMappingURL=http://go/sourcemap/sourcemaps/656af3704923280dedba3ccd49cfaf9b9d456e90/node_modules/rxjs/dist/cjs/internal/observable/onErrorResumeNext.js.map