"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromFetch = void 0;
const Observable_js_1 = require("../../Observable.js");
function fromFetch(input, initWithSelector = {}) {
    const { selector, ...init } = initWithSelector;
    return new Observable_js_1.Observable((destination) => {
        const controller = new AbortController();
        const { signal } = controller;
        let abortable = true;
        const { signal: outerSignal } = init;
        if (outerSignal) {
            if (outerSignal.aborted) {
                controller.abort();
            }
            else {
                const outerSignalHandler = () => {
                    if (!signal.aborted) {
                        controller.abort();
                    }
                };
                outerSignal.addEventListener('abort', outerSignalHandler);
                destination.add(() => outerSignal.removeEventListener('abort', outerSignalHandler));
            }
        }
        const perSubscriberInit = { ...init, signal };
        const handleError = (err) => {
            abortable = false;
            destination.error(err);
        };
        fetch(input, perSubscriberInit)
            .then((response) => {
            if (selector) {
                (0, Observable_js_1.from)(selector(response)).subscribe((0, Observable_js_1.operate)({
                    destination,
                    complete: () => {
                        abortable = false;
                        destination.complete();
                    },
                    error: handleError,
                }));
            }
            else {
                abortable = false;
                destination.next(response);
                destination.complete();
            }
        })
            .catch(handleError);
        return () => {
            if (abortable) {
                controller.abort();
            }
        };
    });
}
exports.fromFetch = fromFetch;//# sourceMappingURL=http://go/sourcemap/sourcemaps/656af3704923280dedba3ccd49cfaf9b9d456e90/node_modules/rxjs/dist/cjs/internal/observable/dom/fetch.js.map