Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const api = require('@opentelemetry/api');
const opentelemetry = require('@sentry/opentelemetry');

/**
 * Update the active isolation scope.
 * Should be used with caution!
 */
function setIsolationScope(isolationScope) {
  const scopes = opentelemetry.getScopesFromContext(api.context.active());
  if (scopes) {
    scopes.isolationScope = isolationScope;
  }
}

exports.setIsolationScope = setIsolationScope;//# sourceMappingURL=http://go/sourcemap/sourcemaps/656af3704923280dedba3ccd49cfaf9b9d456e90/node_modules/@sentry/node-core/build/cjs/sdk/scope.js.map
