import { Observable, operate, COMPLETE_NOTIFICATION, errorNotification, nextNotification } from '../Observable.js';
export function materialize() {
    return (source) => new Observable((destination) => {
        source.subscribe(operate({
            destination,
            next: (value) => {
                destination.next(nextNotification(value));
            },
            error: (error) => {
                destination.next(errorNotification(error));
                destination.complete();
            },
            complete: () => {
                destination.next(COMPLETE_NOTIFICATION);
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/655ee705c6c7b6da1da481d0fdf13191d5e3e980/node_modules/rxjs/dist/esm/internal/operators/materialize.js.map