"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.connectable = void 0;
const Subject_js_1 = require("../Subject.js");
const Observable_js_1 = require("../Observable.js");
const defer_js_1 = require("./defer.js");
const DEFAULT_CONFIG = {
    connector: () => new Subject_js_1.Subject(),
    resetOnDisconnect: true,
};
function connectable(source, config = DEFAULT_CONFIG) {
    let connection = null;
    const { connector, resetOnDisconnect = true } = config;
    let subject = connector();
    const result = new Observable_js_1.Observable((subscriber) => {
        return subject.subscribe(subscriber);
    });
    result.connect = () => {
        if (!connection || connection.closed) {
            connection = (0, defer_js_1.defer)(() => source).subscribe(subject);
            if (resetOnDisconnect) {
                connection.add(() => (subject = connector()));
            }
        }
        return connection;
    };
    return result;
}
exports.connectable = connectable;//# sourceMappingURL=http://go/sourcemap/sourcemaps/655ee705c6c7b6da1da481d0fdf13191d5e3e980/node_modules/rxjs/dist/cjs/internal/observable/connectable.js.map