const core = require('@sentry/core');
const sessions = require('../sessions.js');

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = core.defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            sessions.startSession(!!options.sendOnCreate);
            sessions.endSessionOnExit();
        },
    };
});

exports.mainProcessSessionIntegration = mainProcessSessionIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/655ee705c6c7b6da1da481d0fdf13191d5e3e980/node_modules/@sentry/electron/main/integrations/main-process-session.js.map
