const electron = require('electron');
const version = require('./version.js');

const SDK_NAME = 'sentry.javascript.electron';
/** Gets SDK info */
function getSdkInfo(sendDefaultPii) {
    return {
        name: SDK_NAME,
        packages: [
            {
                name: 'npm:@sentry/electron',
                version: version.SDK_VERSION,
            },
        ],
        version: version.SDK_VERSION,
        settings: { infer_ip: sendDefaultPii ? 'auto' : 'never' },
    };
}
/** Gets the default release name */
function getDefaultReleaseName() {
    const app_name = electron.app.name || electron.app.getName();
    return `${app_name.replace(/\W/g, '-')}@${electron.app.getVersion()}`;
}
/** Gets the default environment */
function getDefaultEnvironment() {
    return electron.app.isPackaged ? 'production' : 'development';
}
/**
 * Gets the default event data by calling all event processors.
 */
async function getEventDefaults(client) {
    let event = { message: 'test' };
    const eventHint = {};
    for (const processor of client.getEventProcessors()) {
        if (event === null)
            break;
        event = await processor(event, eventHint);
    }
    delete event?.message;
    return event || {};
}

exports.SDK_NAME = SDK_NAME;
exports.getDefaultEnvironment = getDefaultEnvironment;
exports.getDefaultReleaseName = getDefaultReleaseName;
exports.getEventDefaults = getEventDefaults;
exports.getSdkInfo = getSdkInfo;//# sourceMappingURL=http://go/sourcemap/sourcemaps/655ee705c6c7b6da1da481d0fdf13191d5e3e980/node_modules/@sentry/electron/main/context.js.map
