import { Scheduler } from '../Scheduler.js';
export class AsyncScheduler extends Scheduler {
    actions = [];
    _active = false;
    _scheduled;
    constructor(SchedulerAction, now = Scheduler.now) {
        super(SchedulerAction, now);
    }
    flush(action) {
        const { actions } = this;
        if (this._active) {
            actions.push(action);
            return;
        }
        let error;
        this._active = true;
        do {
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        } while ((action = actions.shift()));
        this._active = false;
        if (error) {
            while ((action = actions.shift())) {
                action.unsubscribe();
            }
            throw error;
        }
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/655ee705c6c7b6da1da481d0fdf13191d5e3e980/node_modules/rxjs/dist/esm/internal/scheduler/AsyncScheduler.js.map