"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scanInternals = void 0;
const Observable_js_1 = require("../Observable.js");
function scanInternals(accumulator, seed, hasSeed, emitOnNext, emitBeforeComplete, source, destination) {
    let hasState = hasSeed;
    let state = seed;
    let index = 0;
    source.subscribe((0, Observable_js_1.operate)({
        destination,
        next: (value) => {
            const i = index++;
            state = hasState
                ?
                    accumulator(state, value, i)
                :
                    ((hasState = true), value);
            emitOnNext && destination.next(state);
        },
        complete: emitBeforeComplete
            ? () => {
                hasState && destination.next(state);
                destination.complete();
            }
            : undefined,
    }));
}
exports.scanInternals = scanInternals;//# sourceMappingURL=http://go/sourcemap/sourcemaps/655ee705c6c7b6da1da481d0fdf13191d5e3e980/node_modules/rxjs/dist/cjs/internal/operators/scanInternals.js.map