"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.distinct = void 0;
const Observable_js_1 = require("../Observable.js");
const noop_js_1 = require("../util/noop.js");
function distinct(keySelector, flushes) {
    return (source) => new Observable_js_1.Observable((destination) => {
        const distinctKeys = new Set();
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                const key = keySelector ? keySelector(value) : value;
                if (!distinctKeys.has(key)) {
                    distinctKeys.add(key);
                    destination.next(value);
                }
            },
        }));
        flushes && (0, Observable_js_1.from)(flushes).subscribe((0, Observable_js_1.operate)({ destination, next: () => distinctKeys.clear(), complete: noop_js_1.noop }));
    });
}
exports.distinct = distinct;//# sourceMappingURL=http://go/sourcemap/sourcemaps/655ee705c6c7b6da1da481d0fdf13191d5e3e980/node_modules/rxjs/dist/cjs/internal/operators/distinct.js.map