"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.using = void 0;
const Observable_js_1 = require("../Observable.js");
const empty_js_1 = require("./empty.js");
function using(resourceFactory, observableFactory) {
    return new Observable_js_1.Observable((subscriber) => {
        const resource = resourceFactory();
        const result = observableFactory(resource);
        const source = result ? (0, Observable_js_1.from)(result) : empty_js_1.EMPTY;
        source.subscribe(subscriber);
        return () => {
            if (resource) {
                resource.unsubscribe();
            }
        };
    });
}
exports.using = using;//# sourceMappingURL=http://go/sourcemap/sourcemaps/655ee705c6c7b6da1da481d0fdf13191d5e3e980/node_modules/rxjs/dist/cjs/internal/observable/using.js.map