"use client";

// src/useSuspenseQuery.ts
import { QueryObserver, skipToken } from "@tanstack/query-core";
import { useBaseQuery } from "./useBaseQuery.js";
import { defaultThrowOnError } from "./suspense.js";
function useSuspenseQuery(options, queryClient) {
  if (process.env.NODE_ENV !== "production") {
    if (options.queryFn === skipToken) {
      console.error("skipToken is not allowed for useSuspenseQuery");
    }
  }
  return useBaseQuery(
    {
      ...options,
      enabled: true,
      suspense: true,
      throwOnError: defaultThrowOnError,
      placeholderData: void 0
    },
    QueryObserver,
    queryClient
  );
}
export {
  useSuspenseQuery
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/61bd004ca01ebc275047da743a5db0b6650d1090/node_modules/@tanstack/react-query/build/legacy/useSuspenseQuery.js.map