"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AjaxResponse = void 0;
class AjaxResponse {
    originalEvent;
    xhr;
    request;
    type;
    status;
    response;
    responseType;
    loaded;
    total;
    responseHeaders;
    constructor(originalEvent, xhr, request, type = 'download_load') {
        this.originalEvent = originalEvent;
        this.xhr = xhr;
        this.request = request;
        this.type = type;
        const { status, responseType } = xhr;
        this.status = status ?? 0;
        this.responseType = responseType ?? '';
        const allHeaders = xhr.getAllResponseHeaders();
        this.responseHeaders = allHeaders
            ?
                allHeaders.split('\n').reduce((headers, line) => {
                    const index = line.indexOf(': ');
                    headers[line.slice(0, index)] = line.slice(index + 2);
                    return headers;
                }, {})
            : {};
        this.response = xhr.response;
        const { loaded, total } = originalEvent;
        this.loaded = loaded;
        this.total = total;
    }
}
exports.AjaxResponse = AjaxResponse;//# sourceMappingURL=http://go/sourcemap/sourcemaps/618c607a249dd7fd2ffc662c6531143833bebd40/node_modules/rxjs/dist/cjs/internal/ajax/AjaxResponse.js.map