import { Subscription } from '../Observable.js';
export const animationFrameProvider = {
    schedule(callback) {
        let request = requestAnimationFrame;
        let cancel = cancelAnimationFrame;
        const { delegate } = animationFrameProvider;
        if (delegate) {
            request = delegate.requestAnimationFrame;
            cancel = delegate.cancelAnimationFrame;
        }
        const handle = request((timestamp) => {
            cancel = undefined;
            callback(timestamp);
        });
        return new Subscription(() => cancel?.(handle));
    },
    requestAnimationFrame(...args) {
        const { delegate } = animationFrameProvider;
        return (delegate?.requestAnimationFrame || requestAnimationFrame)(...args);
    },
    cancelAnimationFrame(...args) {
        const { delegate } = animationFrameProvider;
        return (delegate?.cancelAnimationFrame || cancelAnimationFrame)(...args);
    },
    delegate: undefined,
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/618c607a249dd7fd2ffc662c6531143833bebd40/node_modules/rxjs/dist/esm/internal/scheduler/animationFrameProvider.js.map