"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.every = void 0;
const Observable_js_1 = require("../Observable.js");
function every(predicate, thisArg) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let index = 0;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                if (!predicate.call(thisArg, value, index++, source)) {
                    destination.next(false);
                    destination.complete();
                }
            },
            complete: () => {
                destination.next(true);
                destination.complete();
            },
        }));
    });
}
exports.every = every;//# sourceMappingURL=http://go/sourcemap/sourcemaps/60d42bed27e5775c43ec0428d8c653c49e58e260/node_modules/rxjs/dist/cjs/internal/operators/every.js.map