import crypto from 'crypto';
import { coerce } from '../bytes.js';
import { from } from './hasher.js';
export const sha256 = from({
    name: 'sha2-256',
    code: 0x12,
    encode: (input) => coerce(crypto.createHash('sha256').update(input).digest())
});
export const sha512 = from({
    name: 'sha2-512',
    code: 0x13,
    encode: input => coerce(crypto.createHash('sha512').update(input).digest())
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/60d42bed27e5775c43ec0428d8c653c49e58e260/node_modules/multiformats/dist/src/hashes/sha2.js.map