const core = require('@sentry/core');
const sessions = require('../sessions.js');

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = core.defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            sessions.startSession(!!options.sendOnCreate);
            sessions.endSessionOnExit();
        },
    };
});

exports.mainProcessSessionIntegration = mainProcessSessionIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/60d42bed27e5775c43ec0428d8c653c49e58e260/node_modules/@sentry/electron/main/integrations/main-process-session.js.map
