const core = require('@sentry/core');

/** Pulls an event and additional envelope items out of an envelope. Returns undefined if there was no event */
function eventFromEnvelope(envelope) {
    let event;
    const attachments = [];
    let profile;
    core.forEachEnvelopeItem(envelope, (item, type) => {
        if (type === 'event' || type === 'transaction' || type === 'feedback') {
            event = Array.isArray(item) ? item[1] : undefined;
        }
        else if (type === 'attachment') {
            const [headers, data] = item;
            attachments.push({
                filename: headers.filename,
                attachmentType: headers.attachment_type,
                contentType: headers.content_type,
                data,
            });
        }
        else if (type === 'profile') {
            profile = item[1];
        }
    });
    return event ? [event, attachments, profile] : undefined;
}

exports.eventFromEnvelope = eventFromEnvelope;//# sourceMappingURL=http://go/sourcemap/sourcemaps/60d42bed27e5775c43ec0428d8c653c49e58e260/node_modules/@sentry/electron/common/envelope.js.map
