"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduled = void 0;
const scheduleObservable_js_1 = require("./scheduleObservable.js");
const schedulePromise_js_1 = require("./schedulePromise.js");
const scheduleArray_js_1 = require("./scheduleArray.js");
const scheduleIterable_js_1 = require("./scheduleIterable.js");
const scheduleAsyncIterable_js_1 = require("./scheduleAsyncIterable.js");
const Observable_js_1 = require("../Observable.js");
const scheduleReadableStreamLike_js_1 = require("./scheduleReadableStreamLike.js");
function scheduled(input, scheduler) {
    const type = (0, Observable_js_1.getObservableInputType)(input);
    switch (type) {
        case Observable_js_1.ObservableInputType.Own:
        case Observable_js_1.ObservableInputType.InteropObservable:
            return (0, scheduleObservable_js_1.scheduleObservable)(input, scheduler);
        case Observable_js_1.ObservableInputType.Promise:
            return (0, schedulePromise_js_1.schedulePromise)(input, scheduler);
        case Observable_js_1.ObservableInputType.ArrayLike:
            return (0, scheduleArray_js_1.scheduleArray)(input, scheduler);
        case Observable_js_1.ObservableInputType.Iterable:
            return (0, scheduleIterable_js_1.scheduleIterable)(input, scheduler);
        case Observable_js_1.ObservableInputType.AsyncIterable:
            return (0, scheduleAsyncIterable_js_1.scheduleAsyncIterable)(input, scheduler);
        case Observable_js_1.ObservableInputType.ReadableStreamLike:
            return (0, scheduleReadableStreamLike_js_1.scheduleReadableStreamLike)(input, scheduler);
    }
}
exports.scheduled = scheduled;//# sourceMappingURL=http://go/sourcemap/sourcemaps/5fafac2382a4f70e802b24a35085474a8f1f8910/node_modules/rxjs/dist/cjs/internal/scheduled/scheduled.js.map