import * as Digest from './digest.js';
export function from({ name, code, encode }) {
    return new Hasher(name, code, encode);
}
/**
 * Hasher represents a hashing algorithm implementation that produces as
 * `MultihashDigest`.
 */
export class Hasher {
    name;
    code;
    encode;
    constructor(name, code, encode) {
        this.name = name;
        this.code = code;
        this.encode = encode;
    }
    digest(input) {
        if (input instanceof Uint8Array) {
            const result = this.encode(input);
            return result instanceof Uint8Array
                ? Digest.create(this.code, result)
                /* c8 ignore next 1 */
                : result.then(digest => Digest.create(this.code, digest));
        }
        else {
            throw Error('Unknown type, must be binary type');
            /* c8 ignore next 1 */
        }
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/5fafac2382a4f70e802b24a35085474a8f1f8910/node_modules/multiformats/dist/src/hashes/hasher.js.map