"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduleArray = void 0;
const Observable_js_1 = require("../Observable.js");
const executeSchedule_js_1 = require("../util/executeSchedule.js");
function scheduleArray(input, scheduler) {
    return new Observable_js_1.Observable((subscriber) => {
        let i = 0;
        const emit = () => {
            if (i === input.length) {
                subscriber.complete();
            }
            else {
                subscriber.next(input[i++]);
                (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, emit);
            }
        };
        return (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, emit);
    });
}
exports.scheduleArray = scheduleArray;//# sourceMappingURL=http://go/sourcemap/sourcemaps/5fafac2382a4f70e802b24a35085474a8f1f8910/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleArray.js.map