"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.every = void 0;
const Observable_js_1 = require("../Observable.js");
function every(predicate, thisArg) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let index = 0;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                if (!predicate.call(thisArg, value, index++, source)) {
                    destination.next(false);
                    destination.complete();
                }
            },
            complete: () => {
                destination.next(true);
                destination.complete();
            },
        }));
    });
}
exports.every = every;//# sourceMappingURL=http://go/sourcemap/sourcemaps/5fafac2382a4f70e802b24a35085474a8f1f8910/node_modules/rxjs/dist/cjs/internal/operators/every.js.map