"use client";

// src/useIsFetching.ts
import * as React from "react";
import { notifyManager } from "@tanstack/query-core";
import { useQueryClient } from "./QueryClientProvider.js";
function useIsFetching(filters, queryClient) {
  const client = useQueryClient(queryClient);
  const queryCache = client.getQueryCache();
  return React.useSyncExternalStore(
    React.useCallback(
      (onStoreChange) => queryCache.subscribe(notifyManager.batchCalls(onStoreChange)),
      [queryCache]
    ),
    () => client.isFetching(filters),
    () => client.isFetching(filters)
  );
}
export {
  useIsFetching
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/5de1e0201c451e9b2865f731faa1e2d4bd875e20/node_modules/@tanstack/react-query/build/modern/useIsFetching.js.map