import { createParser } from "./index.esm.js";
import { ParseError } from "./index.esm.js";
class EventSourceParserStream extends TransformStream {
  constructor({ onError, onRetry, onComment } = {}) {
    let parser;
    super({
      start(controller) {
        parser = createParser({
          onEvent: (event) => {
            controller.enqueue(event);
          },
          onError(error) {
            onError === "terminate" ? controller.error(error) : typeof onError == "function" && onError(error);
          },
          onRetry,
          onComment
        });
      },
      transform(chunk) {
        parser.feed(chunk);
      }
    });
  }
}
export {
  EventSourceParserStream,
  ParseError
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/5de1e0201c451e9b2865f731faa1e2d4bd875e20/node_modules/eventsource-parser/dist/stream.esm.js.map
