import { context } from '@opentelemetry/api';
import { getScopesFromContext } from '@sentry/opentelemetry';

/**
 * Update the active isolation scope.
 * Should be used with caution!
 */
function setIsolationScope(isolationScope) {
  const scopes = getScopesFromContext(context.active());
  if (scopes) {
    scopes.isolationScope = isolationScope;
  }
}

export { setIsolationScope };//# sourceMappingURL=http://go/sourcemap/sourcemaps/5c17eb2968a37f66bc6662f48d6356a100b67be0/node_modules/@sentry/node-core/build/esm/sdk/scope.js.map
