Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

let cachedDebuggerEnabled;

/**
 * Was the debugger enabled when this function was first called?
 */
async function isDebuggerEnabled() {
  if (cachedDebuggerEnabled === undefined) {
    try {
      // Node can be built without inspector support
      const inspector = await import('node:inspector');
      cachedDebuggerEnabled = !!inspector.url();
    } catch {
      cachedDebuggerEnabled = false;
    }
  }

  return cachedDebuggerEnabled;
}

exports.isDebuggerEnabled = isDebuggerEnabled;//# sourceMappingURL=http://go/sourcemap/sourcemaps/5c17eb2968a37f66bc6662f48d6356a100b67be0/node_modules/@sentry/node-core/build/cjs/utils/debug.js.map
