Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const runOnce = (cb) => {
  let called = false;
  return () => {
    if (!called) {
      cb();
      called = true;
    }
  };
};

exports.runOnce = runOnce;//# sourceMappingURL=http://go/sourcemap/sourcemaps/5c17eb2968a37f66bc6662f48d6356a100b67be0/node_modules/@sentry-internal/browser-utils/build/cjs/metrics/web-vitals/lib/runOnce.js.map
