"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.audit = void 0;
const Observable_js_1 = require("../Observable.js");
function audit(durationSelector) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let hasValue = false;
        let lastValue = null;
        let durationSubscriber = null;
        let isComplete = false;
        const endDuration = () => {
            durationSubscriber?.unsubscribe();
            durationSubscriber = null;
            if (hasValue) {
                hasValue = false;
                const value = lastValue;
                lastValue = null;
                destination.next(value);
            }
            isComplete && destination.complete();
        };
        const cleanupDuration = () => {
            durationSubscriber = null;
            isComplete && destination.complete();
        };
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                hasValue = true;
                lastValue = value;
                if (!durationSubscriber) {
                    (0, Observable_js_1.from)(durationSelector(value)).subscribe((durationSubscriber = (0, Observable_js_1.operate)({
                        destination,
                        next: endDuration,
                        complete: cleanupDuration,
                    })));
                }
            },
            complete: () => {
                isComplete = true;
                (!hasValue || !durationSubscriber || durationSubscriber.closed) && destination.complete();
            },
        }));
    });
}
exports.audit = audit;//# sourceMappingURL=http://go/sourcemap/sourcemaps/56f0a83df8e9eb48585fcc4858a9440db4cc7770/node_modules/rxjs/dist/cjs/internal/operators/audit.js.map