import { asyncScheduler } from '../scheduler/async.js';
import { Observable, operate } from '../Observable.js';
import { executeSchedule } from '../util/executeSchedule.js';
export function debounceTime(dueTime, scheduler = asyncScheduler) {
    return (source) => new Observable((destination) => {
        let lastValue;
        let activeTask;
        source.subscribe(operate({
            destination,
            next: (value) => {
                lastValue = value;
                activeTask?.unsubscribe();
                activeTask = executeSchedule(destination, scheduler, () => {
                    activeTask = undefined;
                    const v = lastValue;
                    lastValue = null;
                    destination.next(v);
                }, dueTime);
            },
            complete: () => {
                if (activeTask) {
                    destination.next(lastValue);
                }
                destination.complete();
            },
            finalize: () => {
                lastValue = activeTask = null;
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/56f0a83df8e9eb48585fcc4858a9440db4cc7770/node_modules/rxjs/dist/esm/internal/operators/debounceTime.js.map