function addHeader(responseHeaders = {}, name, value) {
    if (responseHeaders[name]) {
        const existing = responseHeaders[name];
        if (Array.isArray(existing)) {
            existing.push(value);
        }
        else {
            responseHeaders[name] = [existing, value];
        }
    }
    else {
        responseHeaders[name] = value;
    }
    return { responseHeaders };
}
/**
 * Adds a header to a session's web request
 */
function addHeaderToSession(sesh, header, value) {
    sesh.webRequest.onHeadersReceived((details, callback) => {
        callback(addHeader(details.responseHeaders, header, value));
    });
}

export { addHeaderToSession };//# sourceMappingURL=http://go/sourcemap/sourcemaps/55b873ebecb5923d3b947d7e67e841d3ac781880/node_modules/@sentry/electron/esm/main/header-injection.js.map
