import { defineIntegration } from '@sentry/core';
import { anrIntegration as anrIntegration$1 } from '@sentry/node';
import { app, powerMonitor } from 'electron';
import { ELECTRON_MAJOR_VERSION } from '../electron-normalize.js';

/**
 * Starts a worker thread to detect App Not Responding (ANR) events
 *
 * @deprecated The ANR integration has been deprecated. Use `eventLoopBlockIntegration` from `@sentry/electron/native`
 * instead. You will need to install `@sentry/node-native` as a dependency.
 */
const anrIntegration = defineIntegration((options = {}) => {
    if (ELECTRON_MAJOR_VERSION < 22) {
        throw new Error('Main process ANR detection requires Electron v22+');
    }
    // eslint-disable-next-line deprecation/deprecation
    const integration = anrIntegration$1({
        ...options,
        staticTags: {
            'event.environment': 'javascript',
            'event.origin': 'electron',
            'event.process': 'browser',
            ...options.staticTags,
        },
        appRootPath: app.getAppPath(),
    });
    powerMonitor.on('suspend', () => {
        integration.stopWorker();
    });
    powerMonitor.on('lock-screen', () => {
        integration.stopWorker();
    });
    powerMonitor.on('resume', () => {
        integration.startWorker();
    });
    powerMonitor.on('unlock-screen', () => {
        integration.startWorker();
    });
    return integration;
});

export { anrIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/55b873ebecb5923d3b947d7e67e841d3ac781880/node_modules/@sentry/electron/esm/main/integrations/anr.js.map
