import { forEachEnvelopeItem } from '@sentry/core';

/** Pulls an event and additional envelope items out of an envelope. Returns undefined if there was no event */
function eventFromEnvelope(envelope) {
    let event;
    const attachments = [];
    let profile;
    forEachEnvelopeItem(envelope, (item, type) => {
        if (type === 'event' || type === 'transaction' || type === 'feedback') {
            event = Array.isArray(item) ? item[1] : undefined;
        }
        else if (type === 'attachment') {
            const [headers, data] = item;
            attachments.push({
                filename: headers.filename,
                attachmentType: headers.attachment_type,
                contentType: headers.content_type,
                data,
            });
        }
        else if (type === 'profile') {
            profile = item[1];
        }
    });
    return event ? [event, attachments, profile] : undefined;
}

export { eventFromEnvelope };//# sourceMappingURL=http://go/sourcemap/sourcemaps/55b873ebecb5923d3b947d7e67e841d3ac781880/node_modules/@sentry/electron/esm/common/envelope.js.map
