import { EmptyError } from '../util/EmptyError.js';
import { Observable, operate } from '../Observable.js';
export function throwIfEmpty(errorFactory = defaultErrorFactory) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => (hasValue ? destination.complete() : destination.error(errorFactory())),
        }));
    });
}
function defaultErrorFactory() {
    return new EmptyError();
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/4ca9b38c6c97d4243bf0c61e51426667cb964bd0/node_modules/rxjs/dist/esm/internal/operators/throwIfEmpty.js.map