"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bufferCount = void 0;
const Observable_js_1 = require("../Observable.js");
const arrRemove_js_1 = require("../util/arrRemove.js");
function bufferCount(bufferSize, startBufferEvery = null) {
    startBufferEvery = startBufferEvery ?? bufferSize;
    return (source) => new Observable_js_1.Observable((destination) => {
        let buffers = [];
        let count = 0;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                let toEmit = null;
                if (count++ % startBufferEvery === 0) {
                    buffers.push([]);
                }
                for (const buffer of buffers) {
                    buffer.push(value);
                    if (bufferSize <= buffer.length) {
                        toEmit = toEmit ?? [];
                        toEmit.push(buffer);
                    }
                }
                if (toEmit) {
                    for (const buffer of toEmit) {
                        (0, arrRemove_js_1.arrRemove)(buffers, buffer);
                        destination.next(buffer);
                    }
                }
            },
            complete: () => {
                for (const buffer of buffers) {
                    destination.next(buffer);
                }
                destination.complete();
            },
            finalize: () => {
                buffers = null;
            },
        }));
    });
}
exports.bufferCount = bufferCount;//# sourceMappingURL=http://go/sourcemap/sourcemaps/4ca9b38c6c97d4243bf0c61e51426667cb964bd0/node_modules/rxjs/dist/cjs/internal/operators/bufferCount.js.map