import { from } from '../Observable.js';
import { mergeAll } from '../operators/mergeAll.js';
import { EMPTY } from './empty.js';
import { popNumber, popScheduler } from '../util/args.js';
import { scheduled } from '../scheduled/scheduled.js';
export function merge(...args) {
    const scheduler = popScheduler(args);
    const concurrent = popNumber(args, Infinity);
    const sources = args;
    return !sources.length
        ?
            EMPTY
        : sources.length === 1
            ?
                from(sources[0])
            :
                mergeAll(concurrent)(scheduler ? scheduled(sources, scheduler) : from(sources));
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/4ca9b38c6c97d4243bf0c61e51426667cb964bd0/node_modules/rxjs/dist/esm/internal/observable/merge.js.map