"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncScheduler = void 0;
const Scheduler_js_1 = require("../Scheduler.js");
class AsyncScheduler extends Scheduler_js_1.Scheduler {
    actions = [];
    _active = false;
    _scheduled;
    constructor(SchedulerAction, now = Scheduler_js_1.Scheduler.now) {
        super(SchedulerAction, now);
    }
    flush(action) {
        const { actions } = this;
        if (this._active) {
            actions.push(action);
            return;
        }
        let error;
        this._active = true;
        do {
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        } while ((action = actions.shift()));
        this._active = false;
        if (error) {
            while ((action = actions.shift())) {
                action.unsubscribe();
            }
            throw error;
        }
    }
}
exports.AsyncScheduler = AsyncScheduler;//# sourceMappingURL=http://go/sourcemap/sourcemaps/4ca9b38c6c97d4243bf0c61e51426667cb964bd0/node_modules/rxjs/dist/cjs/internal/scheduler/AsyncScheduler.js.map