"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsapScheduler = void 0;
const AsyncScheduler_js_1 = require("./AsyncScheduler.js");
class AsapScheduler extends AsyncScheduler_js_1.AsyncScheduler {
    flush(action) {
        this._active = true;
        const flushId = this._scheduled;
        this._scheduled = undefined;
        const { actions } = this;
        let error;
        action = action || actions.shift();
        do {
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        } while ((action = actions[0]) && action.id === flushId && actions.shift());
        this._active = false;
        if (error) {
            while ((action = actions[0]) && action.id === flushId && actions.shift()) {
                action.unsubscribe();
            }
            throw error;
        }
    }
}
exports.AsapScheduler = AsapScheduler;//# sourceMappingURL=http://go/sourcemap/sourcemaps/4ca9b38c6c97d4243bf0c61e51426667cb964bd0/node_modules/rxjs/dist/cjs/internal/scheduler/AsapScheduler.js.map