const core = require('@sentry/core');

/** Pulls an event and additional envelope items out of an envelope. Returns undefined if there was no event */
function eventFromEnvelope(envelope) {
    let event;
    const attachments = [];
    let profile;
    core.forEachEnvelopeItem(envelope, (item, type) => {
        if (type === 'event' || type === 'transaction' || type === 'feedback') {
            event = Array.isArray(item) ? item[1] : undefined;
        }
        else if (type === 'attachment') {
            const [headers, data] = item;
            attachments.push({
                filename: headers.filename,
                attachmentType: headers.attachment_type,
                contentType: headers.content_type,
                data,
            });
        }
        else if (type === 'profile') {
            profile = item[1];
        }
    });
    return event ? [event, attachments, profile] : undefined;
}

exports.eventFromEnvelope = eventFromEnvelope;//# sourceMappingURL=http://go/sourcemap/sourcemaps/4ca9b38c6c97d4243bf0c61e51426667cb964bd0/node_modules/@sentry/electron/common/envelope.js.map
