const core = require('@sentry/core');

/** Gets the merged scope data */
function getScopeData() {
    const globalScope = core.getGlobalScope().getScopeData();
    const isolationScope = core.getIsolationScope().getScopeData();
    const currentScope = core.getCurrentScope().getScopeData();
    core.mergeScopeData(globalScope, isolationScope);
    core.mergeScopeData(globalScope, currentScope);
    globalScope.eventProcessors = [];
    return globalScope;
}
/** Hooks both current and isolation scope changes and passes merged scope on changes  */
function addScopeListener(callback) {
    core.getIsolationScope().addScopeListener((isolation) => {
        const merged = getScopeData();
        callback(merged, isolation);
    });
    core.getCurrentScope().addScopeListener((current) => {
        const merged = getScopeData();
        callback(merged, current);
    });
    core.getGlobalScope().addScopeListener((global) => {
        const merged = getScopeData();
        callback(merged, global);
    });
}

exports.addScopeListener = addScopeListener;
exports.getScopeData = getScopeData;//# sourceMappingURL=http://go/sourcemap/sourcemaps/4aa02949dc5065af49f2f6f72e3278386a3f7110/node_modules/@sentry/electron/common/scope.js.map
