import crypto from 'crypto';
import { coerce } from '../bytes.js';
import { from } from './hasher.js';
export const sha256 = from({
    name: 'sha2-256',
    code: 0x12,
    encode: (input) => coerce(crypto.createHash('sha256').update(input).digest())
});
export const sha512 = from({
    name: 'sha2-512',
    code: 0x13,
    encode: input => coerce(crypto.createHash('sha512').update(input).digest())
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/4aa02949dc5065af49f2f6f72e3278386a3f7110/node_modules/multiformats/dist/src/hashes/sha2.js.map