import { getDefaultIntegrations as getDefaultIntegrations$1, init as init$1 } from '@sentry/browser';
import { debug } from '@sentry/core';
import { eventLoopBlockIntegration } from './integrations/event-loop-block.js';
import { scopeToMainIntegration } from './integrations/scope-to-main.js';
import { electronRendererStackParser } from './stack-parse.js';
import { makeRendererTransport } from './transport.js';

/* eslint-disable deprecation/deprecation */
/* eslint-disable no-restricted-globals */
/** Get the default integrations for the renderer SDK. */
function getDefaultIntegrations(options) {
    return [
        ...getDefaultIntegrations$1(options).filter((i) => i.name !== 'BrowserSession'),
        scopeToMainIntegration(),
    ];
}
/**
 * Initialize Sentry in the Electron renderer process
 * @param options SDK options
 * @param originalInit Optional init function for a specific framework SDK
 * @returns
 */
function init(options = {}, 
// This parameter name ensures that TypeScript error messages contain a hint for fixing SDK version mismatches
originalInit = init$1) {
    // Ensure the browser SDK is only init'ed once.
    if (window?.__SENTRY__RENDERER_INIT__) {
        debug.warn(`The browser SDK has already been initialized.
If init has been called in the preload and contextIsolation is disabled, is not required to call init in the renderer`);
        return;
    }
    window.__SENTRY__RENDERER_INIT__ = true;
    // Disable client reports for renderer as the sdk should only send
    // events using the main process.
    options.sendClientReports = false;
    if (options.defaultIntegrations === undefined) {
        options.defaultIntegrations = getDefaultIntegrations(options);
    }
    if (options.stackParser === undefined) {
        options.stackParser = electronRendererStackParser;
    }
    // eslint-disable-next-line deprecation/deprecation
    if (options.dsn === undefined) {
        // Events are sent via the main process but browser SDK wont start without dsn
        // eslint-disable-next-line deprecation/deprecation
        options.dsn = 'https://12345@dummy.dsn/12345';
    }
    if (options.transport === undefined) {
        options.transport = makeRendererTransport;
    }
    // TODO: Next major version, remove the deprecated anrDetection option
    if (options.anrDetection) {
        const integrationOptions = options.anrDetection === true
            ? {
                threshold: 5000,
                pollInterval: 1000,
                captureStackTrace: false,
            }
            : {
                threshold: options.anrDetection.anrThreshold || 5000,
                pollInterval: options.anrDetection.pollInterval || 1000,
                captureStackTrace: options.anrDetection.captureStackTrace || false,
            };
        const integration = eventLoopBlockIntegration(integrationOptions);
        if (typeof options.integrations === 'function') {
            const originalFn = options.integrations;
            options.integrations = (integrations) => [...originalFn(integrations), integration];
        }
        else {
            options.integrations = options.integrations || [];
            options.integrations.push(integration);
        }
    }
    // We only handle initialScope in the main process otherwise it can cause race conditions over IPC
    delete options.initialScope;
    originalInit(options);
}

export { getDefaultIntegrations, init };//# sourceMappingURL=http://go/sourcemap/sourcemaps/493c403e4a45c5f971d1c76cc74febd0968d57d0/node_modules/@sentry/electron/esm/renderer/sdk.js.map
