import { base58btc } from './bases/base58.js';
export async function walk({ cid, load, seen }) {
    seen = seen ?? new Set();
    const b58Cid = cid.toString(base58btc);
    if (seen.has(b58Cid)) {
        return;
    }
    const block = await load(cid);
    seen.add(b58Cid);
    if (block === null) { // the loader signals with `null` that we should skip this block
        return;
    }
    for (const [, cid] of block.links()) {
        await walk({ cid, load, seen });
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/45fd70f3fe72037444ba35c9e51ce86a1977ac10/node_modules/multiformats/dist/src/traversal.js.map