import { operate, Observable, from } from '../Observable.js';
import { noop } from '../util/noop.js';
export function debounce(durationSelector) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        let lastValue = null;
        let durationSubscriber = null;
        const emit = () => {
            durationSubscriber?.unsubscribe();
            durationSubscriber = null;
            if (hasValue) {
                hasValue = false;
                const value = lastValue;
                lastValue = null;
                destination.next(value);
            }
        };
        source.subscribe(operate({
            destination,
            next: (value) => {
                durationSubscriber?.unsubscribe();
                hasValue = true;
                lastValue = value;
                durationSubscriber = operate({ destination, next: emit, complete: noop });
                from(durationSelector(value)).subscribe(durationSubscriber);
            },
            complete: () => {
                emit();
                destination.complete();
            },
            finalize: () => {
                lastValue = durationSubscriber = null;
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/44f52350f2b7b9ee7625cfaade862ff53a016f40/node_modules/rxjs/dist/esm/internal/operators/debounce.js.map