"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generate = void 0;
const identity_js_1 = require("../util/identity.js");
const isScheduler_js_1 = require("../util/isScheduler.js");
const defer_js_1 = require("./defer.js");
const scheduleIterable_js_1 = require("../scheduled/scheduleIterable.js");
function generate(initialStateOrOptions, condition, iterate, resultSelectorOrScheduler, scheduler) {
    let resultSelector;
    let initialState;
    if (arguments.length === 1) {
        ({
            initialState,
            condition,
            iterate,
            resultSelector = identity_js_1.identity,
            scheduler,
        } = initialStateOrOptions);
    }
    else {
        initialState = initialStateOrOptions;
        if (!resultSelectorOrScheduler || (0, isScheduler_js_1.isScheduler)(resultSelectorOrScheduler)) {
            resultSelector = identity_js_1.identity;
            scheduler = resultSelectorOrScheduler;
        }
        else {
            resultSelector = resultSelectorOrScheduler;
        }
    }
    function* gen() {
        for (let state = initialState; !condition || condition(state); state = iterate(state)) {
            yield resultSelector(state);
        }
    }
    return (0, defer_js_1.defer)((scheduler
        ?
            () => (0, scheduleIterable_js_1.scheduleIterable)(gen(), scheduler)
        :
            gen));
}
exports.generate = generate;//# sourceMappingURL=http://go/sourcemap/sourcemaps/44f52350f2b7b9ee7625cfaade862ff53a016f40/node_modules/rxjs/dist/cjs/internal/observable/generate.js.map