import { diag, DiagLogLevel } from '@opentelemetry/api';
import { debug } from '@sentry/core';

/**
 * Setup the OTEL logger to use our own debug logger.
 */
function setupOpenTelemetryLogger() {
  // Disable diag, to ensure this works even if called multiple times
  diag.disable();
  diag.setLogger(
    {
      error: debug.error,
      warn: debug.warn,
      info: debug.log,
      debug: debug.log,
      verbose: debug.log,
    },
    DiagLogLevel.DEBUG,
  );
}

export { setupOpenTelemetryLogger };//# sourceMappingURL=http://go/sourcemap/sourcemaps/44f52350f2b7b9ee7625cfaade862ff53a016f40/node_modules/@sentry/node-core/build/esm/otel/logger.js.map
