import { Observable, operate } from '../Observable.js';
export function takeWhile(predicate, inclusive = false) {
    return (source) => new Observable((destination) => {
        let index = 0;
        const operatorSubscriber = operate({
            destination,
            next: (value) => {
                if (predicate(value, index++)) {
                    destination.next(value);
                }
                else {
                    operatorSubscriber.unsubscribe();
                    if (inclusive) {
                        destination.next(value);
                    }
                    destination.complete();
                }
            },
        });
        source.subscribe(operatorSubscriber);
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/44f52350f2b7b9ee7625cfaade862ff53a016f40/node_modules/rxjs/dist/esm/internal/operators/takeWhile.js.map